/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.logging.LogUtils;
import java.lang.ref.Cleaner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.GlQueryObject;
import qouteall.imm_ptl.core.render.QueryManager;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

@Environment(value=EnvType.CLIENT)
public class PortalRenderInfo
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<List<UUID>, Visibility> infoMap = new HashMap<List<UUID>, Visibility>();
    public int thisFrameQueryFrameIndex = -1;
    private long mispredictTime1 = 0L;
    private long mispredictTime2 = 0L;
    private int totalMispredictCount = 0;
    private static final Cleaner CLEANER = Cleaner.create();

    public static void init() {
        Portal.CLIENT_PORTAL_TICK_SIGNAL.register(portal -> {
            PortalRenderInfo presentation = PortalRenderInfo.getOptional(portal);
            if (presentation != null) {
                presentation.tick((Portal)portal);
            }
        });
        Portal.PORTAL_DISPOSE_SIGNAL.register(portal -> {
            PortalRenderInfo renderInfo;
            if (portal.method_37908().method_8608() && (renderInfo = PortalRenderInfo.getOptional(portal)) != null) {
                renderInfo.dispose();
            }
        });
    }

    @Nullable
    public static PortalRenderInfo getOptional(Portal portal) {
        Validate.isTrue((boolean)portal.method_37908().method_8608());
        return portal.portalRenderInfo;
    }

    public static PortalRenderInfo get(Portal portal) {
        Validate.isTrue((boolean)portal.method_37908().method_8608());
        if (portal.portalRenderInfo == null) {
            portal.portalRenderInfo = new PortalRenderInfo();
        }
        return portal.portalRenderInfo;
    }

    public PortalRenderInfo() {
        CLEANER.register(this, this.getGcDirectedCleaningFunc());
    }

    private void tick(Portal portal) {
        Validate.isTrue((boolean)portal.method_37908().method_8608());
    }

    public void dispose() {
        PortalRenderInfo.disposeInfoMap(this.infoMap);
    }

    private Runnable getGcDirectedCleaningFunc() {
        Map<List<UUID>, Visibility> infoMap1 = this.infoMap;
        return () -> {
            LOGGER.debug("Running GC-directed PortalRenderInfo clean");
            IPGlobal.PRE_TOTAL_RENDER_TASK_LIST.addOneShotTask(() -> PortalRenderInfo.disposeInfoMap(infoMap1));
        };
    }

    @Override
    public void close() throws Exception {
        this.dispose();
    }

    private static void disposeInfoMap(Map<List<UUID>, Visibility> infoMap) {
        infoMap.values().forEach(Visibility::dispose);
        infoMap.clear();
    }

    private void updateQuerySet() {
        if (RenderStates.frameIndex != this.thisFrameQueryFrameIndex) {
            if (RenderStates.frameIndex == this.thisFrameQueryFrameIndex + 1) {
                this.infoMap.entrySet().removeIf(entry -> {
                    Visibility visibility = (Visibility)entry.getValue();
                    return visibility.lastFrameQuery == null && visibility.thisFrameQuery == null;
                });
                this.infoMap.values().forEach(Visibility::update);
            } else {
                PortalRenderInfo.disposeInfoMap(this.infoMap);
            }
            this.thisFrameQueryFrameIndex = RenderStates.frameIndex;
        }
    }

    @NotNull
    private Visibility getVisibility(List<UUID> desc) {
        this.updateQuerySet();
        return this.infoMap.computeIfAbsent(desc, k -> new Visibility());
    }

    private void onMispredict() {
        this.mispredictTime1 = this.mispredictTime2;
        this.mispredictTime2 = System.nanoTime();
        ++this.totalMispredictCount;
    }

    private boolean isFrequentlyMispredicted() {
        if (this.totalMispredictCount > 5) {
            return true;
        }
        long currTime = System.nanoTime();
        return currTime - this.mispredictTime1 < Helper.secondToNano(30.0);
    }

    private void updatePredictionStatus(Visibility visibility, boolean thisFrameDecision) {
        visibility.thisFrameRendered = thisFrameDecision;
        if (thisFrameDecision && visibility.lastFrameRendered != null && !visibility.lastFrameRendered.booleanValue() && !this.isFrequentlyMispredicted()) {
            this.onMispredict();
        }
    }

    public static boolean renderAndDecideVisibility(Portal portal, Runnable queryRendering) {
        boolean decision;
        class_3695 profiler = class_310.method_1551().method_16011();
        if (IPGlobal.offsetOcclusionQuery) {
            boolean noPredict;
            PortalRenderInfo renderInfo = PortalRenderInfo.get(portal);
            List<UUID> renderingDescription = WorldRenderInfo.getRenderingDescription();
            Visibility visibility = renderInfo.getVisibility(renderingDescription);
            GlQueryObject lastFrameQuery = visibility.lastFrameQuery;
            GlQueryObject thisFrameQuery = visibility.acquireThisFrameQuery();
            thisFrameQuery.performQueryAnySamplePassed(queryRendering);
            boolean bl = noPredict = renderInfo.isFrequentlyMispredicted() || QueryManager.queryStallCounter <= 3;
            if (lastFrameQuery != null) {
                boolean lastFrameVisible = lastFrameQuery.fetchQueryResult();
                if (!lastFrameVisible && noPredict) {
                    profiler.method_15396("fetch_this_frame");
                    decision = thisFrameQuery.fetchQueryResult();
                    profiler.method_15407();
                    ++QueryManager.queryStallCounter;
                } else {
                    decision = lastFrameVisible;
                    renderInfo.updatePredictionStatus(visibility, decision);
                }
            } else {
                profiler.method_15396("fetch_this_frame");
                decision = thisFrameQuery.fetchQueryResult();
                profiler.method_15407();
                ++QueryManager.queryStallCounter;
            }
        } else {
            decision = QueryManager.renderAndGetDoesAnySamplePass(queryRendering);
        }
        return decision;
    }

    public static class Visibility {
        public GlQueryObject lastFrameQuery = null;
        public GlQueryObject thisFrameQuery = null;
        public Boolean lastFrameRendered = null;
        public Boolean thisFrameRendered;

        void update() {
            if (this.lastFrameQuery != null) {
                GlQueryObject.returnQueryObject(this.lastFrameQuery);
            }
            this.lastFrameQuery = this.thisFrameQuery;
            this.thisFrameQuery = null;
            this.lastFrameRendered = this.thisFrameRendered;
            this.thisFrameRendered = null;
        }

        void dispose() {
            if (this.lastFrameQuery != null) {
                GlQueryObject.returnQueryObject(this.lastFrameQuery);
            }
            if (this.thisFrameQuery != null) {
                GlQueryObject.returnQueryObject(this.thisFrameQuery);
            }
        }

        GlQueryObject acquireThisFrameQuery() {
            if (this.thisFrameQuery == null) {
                this.thisFrameQuery = GlQueryObject.acquireQueryObject();
            }
            return this.thisFrameQuery;
        }
    }
}

